<?php

namespace Balik\Controllers;

use Balik\Models\Branch;
use Balik\Models\Day;
use Balik\Models\OpeningHour;
use Illuminate\Database\Capsule\Manager as Capsule;
use Slim\Http\Request;
use Slim\Http\Response;

class ServiceController extends Controller
{
    /**
     * @param Request $request
     * @param Response $response
     * @return Response
     */
    public function syncData($request, $response)
    {
        ini_set('memory_limit', '-1');
        $xml = simplexml_load_file($this->container["settings"]["source_xml"], null, LIBXML_NOCDATA);
        $json = json_encode($xml);
        $array = json_decode($json, true);

        if ($array) {
            Capsule::select("DELETE FROM days;");
            Capsule::select("ALTER TABLE days AUTO_INCREMENT = 1;");

            Capsule::select("DELETE FROM opening_hours;");
            Capsule::select("ALTER TABLE opening_hours AUTO_INCREMENT = 1;");

            Capsule::select("DELETE FROM branches;");
            Capsule::select("ALTER TABLE branches AUTO_INCREMENT = 1;");

            $this->createDays();

            foreach ($array["row"] as $item) {
                $branch = new Branch();
                $branch->PSC = $item["PSC"];
                $branch->NAZ_PROV = $item["NAZ_PROV"];
                $branch->OKRES = $item["OKRES"];
                $branch->ADRESA = $item["ADRESA"];
                $branch->V_PROVOZU = $this->toBoolean($item["V_PROVOZU"]);
                $branch->PRODL_DOBA = $this->toBoolean($item["PRODL_DOBA"]);
                $branch->BANKOMAT = $this->toBoolean($item["BANKOMAT"]);
                $branch->PARKOVISTE = $this->toBoolean($item["PARKOVISTE"]);
                $branch->KOMPLET_SERVIS = $this->toBoolean($item["KOMPLET_SERVIS"]);
                $branch->VIKEND = $this->toBoolean($item["VIKEND"]);
                $branch->LOKALITY_PRODL = $this->toBoolean($item["LOKALITY_PRODL"]);
                if (!empty($item["VYDEJ_NP_OD"])) {
                    $branch->VYDEJ_NP_OD = $item["VYDEJ_NP_OD"];
                }

                $branch->UKL_NP_LIMIT = $this->toBoolean($item["UKL_NP_LIMIT"]);
                if (!empty($item["PSC_NP_NAHR"])) {
                    $branch->PSC_NP_NAHR = $item["PSC_NP_NAHR"];
                }

                if (!empty($item["NAZ_NP_NAHR"])) {
                    $branch->NAZ_NP_NAHR = $item["NAZ_NP_NAHR"];
                }
                $branch->ABC_BOX = $this->toBoolean($item["ABC_BOX"]);

                $branch->OBEC = $item["OBEC"];

                if (!empty($item["C_OBCE"])) {
                    $branch->C_OBCE = $item["C_OBCE"];
                }

                $branch->save();

                foreach ($item["OTV_DOBA"] as $days) {
                    foreach ($days as $day) {
                        $dayName = $day["@attributes"]["name"];
                        $selectedDay = Day::where('name', $dayName)->first();
                        if (key_exists("od_do", $day)) {
                            if (key_exists("od", $day["od_do"])) {
                                $from = $day["od_do"]["od"];
                                $to = $day["od_do"]["do"];
                                $this->saveOpeningHour($branch, $selectedDay, $from, $to);
                            } else {
                                foreach ($day["od_do"] as $opening) {
                                    $from = $opening["od"];
                                    $to = $opening["do"];
                                    $this->saveOpeningHour($branch, $selectedDay, $from, $to);
                                }
                            }
                        }
                    }
                }

            }

            return $response->withJson(['OK'], 200);
        } else {
            return $response->withJson(['ERROR'], 200);
        }
    }

    private function toBoolean($value) {
        if (strtolower($value) == "a") {
            return 1;
        } else {
            return 0;
        }
    }

    private function saveOpeningHour($branch, $day, $from, $to)
    {
        $openingHour = new OpeningHour();
        $openingHour->branch_id = $branch->id;
        $openingHour->day_id = $day->id;
        $openingHour->open_from = $from;
        $openingHour->open_to = $to;
        $openingHour->save();
    }

    private function createDays()
    {
        $days = ["Pondělí", "Úterý", "Středa", "Čtvrtek", "Pátek", "Sobota", "Neděle"];
        foreach ($days as $day) {
            $d = new Day();
            $d->name = $day;
            $d->save();
        }
    }
}