<?php

namespace Balik\Models;

use Illuminate\Database\Eloquent\Model;

class Branch extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'branches';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    public static function searchBranches($term)
    {
        if (empty($term) or $term === null) {
            $branches = Branch::orderByRaw('OBEC COLLATE utf8_czech_ci')
                ->orderByRaw('C_OBCE COLLATE utf8_czech_ci')
                ->get();
        } elseif (ctype_digit($term)) {
            // search only base on ZIP code
            $branches = Branch::where("PSC", "LIKE", "$term%")
                ->orderByRaw("OBEC COLLATE utf8_czech_ci")
                ->orderByRaw("C_OBCE COLLATE utf8_czech_ci")
                ->get();
        } else {
            // first search by city
            $branchesIds = [];
            $branches = [];
            $branchesCity = Branch::where(function ($q) use ($term) {
                $q->where("OBEC", "LIKE", "$term%")
                    ->orWhere("OBEC", "LIKE", "% $term%");
            })
                ->orderByRaw("OBEC COLLATE utf8_czech_ci")
                ->orderByRaw("C_OBCE COLLATE utf8_czech_ci")
                ->get();

            foreach ($branchesCity as $item) {
                $branchesIds[] = $item->id;
                $branches[] = $item;
            }

            // secondary by city part
            $branchesParts = Branch::where(function ($q) use ($term) {
                $q->where("C_OBCE", "LIKE", "$term%")
                    ->orWhere("C_OBCE", "LIKE", "% $term%");
            })
                ->orderByRaw("OBEC COLLATE utf8_czech_ci")
                ->orderByRaw("C_OBCE COLLATE utf8_czech_ci")
                ->get();

            foreach ($branchesParts as $item) {
                if (!in_array($item->id, $branchesIds)) {
                    $branchesIds[] = $item->id;
                    $branches[] = $item;
                }
            }

            // by address
            $branchesAddress = Branch::where(function ($q) use ($term) {
                $q->where("ADRESA", "LIKE", "$term%")
                    ->orWhere("ADRESA", "LIKE", "% $term%");
            })
                ->orderByRaw("OBEC COLLATE utf8_czech_ci")
                ->orderByRaw("C_OBCE COLLATE utf8_czech_ci")
                ->get();

            foreach ($branchesAddress as $item) {
                if (!in_array($item->id, $branchesIds)) {
                    $branchesIds[] = $item->id;
                    $branches[] = $item;
                }
            }

        }

        $data = [];

        foreach ($branches as $branch) {
            $data[] = [
                "id" => $branch->id,
                "city" => $branch->OBEC,
                "city_part" => $branch->C_OBCE,
                "address" => $branch->ADRESA,
                "atm" => $branch->BANKOMAT,
                "service" => $branch->KOMPLET_SERVIS,
                "parking" => $branch->PARKOVISTE,
                "extended" => $branch->PRODL_DOBA,
            ];
        }

        return $data;
    }
}